// Backend API Configuration
const API_BASE_URL = "http://eframeehs.in:8000";
// const API_BASE_URL = "http://localhost:3000";

// Helper function to build full API URLs
const buildApiUrl = (endpoint) => {
  // Remove leading slash if present to avoid double slashes
  const cleanEndpoint = endpoint.startsWith("/") ? endpoint.slice(1) : endpoint;
  return `${API_BASE_URL}/${cleanEndpoint}`;
};

// Common API endpoints
const API_ENDPOINTS = {
  // Employee Log
  EMPLOYEE_LOG: "api/employee_log/",
};

module.exports = {
  API_BASE_URL,
  buildApiUrl,
  API_ENDPOINTS,
};
