import React from "react";
import { useTheme } from "../../contexts/ThemeContext";
import { FaClipboardList } from "react-icons/fa";

const EmployeeLogHeader = () => {
  const { isLight } = useTheme();

  const cardBgClass = isLight
    ? "bg-white border border-yellow-200 shadow-md hover:shadow-lg"
    : "bg-gradient-to-br from-gray-800 to-slate-800 border border-gray-700 shadow-lg hover:shadow-xl";

  const headingClass = isLight ? "text-amber-800" : "text-gray-100";

  const textClass = isLight ? "text-amber-700" : "text-gray-300";

  return (
    <div
      className={`${cardBgClass} rounded-xl px-4 sm:px-6 py-3 sm:py-4 transition-all duration-300`}
    >
      <div>
        <h1
          className={`text-xl sm:text-2xl font-bold ${headingClass} mb-1 flex items-center gap-2`}
        >
          <FaClipboardList
            className={`${
              isLight ? "text-amber-600" : "text-gray-400"
            } text-lg sm:text-xl`}
          />
          <span className="truncate">Employee Activity Log</span>
        </h1>
        <p className={`${textClass} text-sm`}>
          Track and monitor employee activities and engagement
        </p>
      </div>
    </div>
  );
};

export default EmployeeLogHeader;
