import React, { useState } from "react";
import { FaFileAlt, FaPlus } from "react-icons/fa";
import { useTheme } from "../../contexts/ThemeContext";
import AddFormModal from "./AddFormModal";

const FormsHeader = ({ onAddForm }) => {
  const { isLight } = useTheme();
  const [isAddModalOpen, setIsAddModalOpen] = useState(false);

  // Theme-based styling classes
  const cardBgClass = isLight
    ? "bg-white border border-yellow-200 shadow-md hover:shadow-lg"
    : "bg-gradient-to-br from-gray-800 to-slate-800 border border-gray-700 shadow-lg hover:shadow-xl";

  const headingClass = isLight ? "text-amber-800" : "text-gray-100";
  const textClass = isLight ? "text-amber-700" : "text-gray-300";
  const buttonClass = isLight
    ? "bg-gradient-to-r from-yellow-500 to-amber-500 hover:from-yellow-600 hover:to-amber-600 text-white"
    : "bg-gradient-to-r from-gray-600 to-slate-600 hover:from-gray-500 hover:to-slate-500 text-white";

  return (
    <div className={`${cardBgClass} rounded-xl px-4 sm:px-6 py-3 sm:py-4 transition-all duration-300`}>
      <div className="flex flex-col sm:flex-row sm:items-center justify-between gap-3 sm:gap-4">
        <div className="min-w-0">
          <h1 className={`text-xl sm:text-2xl font-bold ${headingClass} mb-1 flex items-center gap-2`}>
            <FaFileAlt className={`${isLight ? "text-amber-600" : "text-gray-400"} text-lg sm:text-xl`} />
            <span className="truncate">Kick-off Forms</span>
          </h1>
          <p className={`${textClass} text-sm`}>
            Manage and review project kick-off forms
          </p>
        </div>
        <div className="flex gap-2">
          <button 
            onClick={() => setIsAddModalOpen(true)}
            className={`px-3 py-2 ${buttonClass} rounded-lg flex items-center gap-2 transition-all duration-200 hover:scale-105 active:scale-95 text-sm flex-shrink-0 w-full sm:w-auto justify-center sm:justify-start`}
          >
            <FaPlus />
            <span>Add Form</span>
          </button>
        </div>
      </div>
      
      {/* Add Form Modal */}
      <AddFormModal
        isOpen={isAddModalOpen}
        onClose={() => setIsAddModalOpen(false)}
        onSubmit={onAddForm}
      />
    </div>
  );
};

export default FormsHeader;
