import React from 'react';
import { useTheme } from '../../contexts/ThemeContext';

const LeadAvatar = ({ avatar, name }) => {
  const { isLight } = useTheme();

  return (
    <div className={`w-10 h-10 rounded-full flex items-center justify-center font-semibold text-white ${
      isLight ? 'bg-amber-500' : 'bg-gray-600'
    }`} title={name}>
      {avatar}
    </div>
  );
};

export default LeadAvatar; 