import React from 'react';
import { useTheme } from '../../contexts/ThemeContext';

const SummaryCard = ({ title, value, icon: Icon, iconColor }) => {
  const { isLight } = useTheme();

  const cardBgClass = isLight 
    ? 'bg-white border border-yellow-200 shadow-md hover:shadow-lg' 
    : 'bg-gradient-to-br from-gray-800 to-slate-800 border border-gray-700 shadow-lg hover:shadow-xl';
  
  const headingClass = isLight 
    ? 'text-amber-800' 
    : 'text-gray-100';
  
  const textClass = isLight 
    ? 'text-amber-700' 
    : 'text-gray-300';

  return (
    <div className={`${cardBgClass} rounded-xl p-6 transition-all duration-300 hover:scale-105`}>
      <div className="flex items-center justify-between">
        <div>
          <p className={`${textClass} text-sm`}>{title}</p>
          <p className={`text-2xl font-bold ${headingClass}`}>{value}</p>
        </div>
        <div className={`text-3xl ${iconColor}`}>
          <Icon />
        </div>
      </div>
    </div>
  );
};

export default SummaryCard; 