import React from 'react';
import { useTheme } from '../../contexts/ThemeContext';
import { FaSpinner } from 'react-icons/fa';

const LoadingState = () => {
  const { isLight } = useTheme();

  const cardBgClass = isLight 
    ? 'bg-white border border-yellow-200 shadow-md hover:shadow-lg' 
    : 'bg-gradient-to-br from-gray-800 to-slate-800 border border-gray-700 shadow-lg hover:shadow-xl';
  
  const textClass = isLight 
    ? 'text-amber-700' 
    : 'text-gray-300';

  return (
    <div className={`${cardBgClass} rounded-xl p-6 sm:p-8 transition-all duration-300`}>
      <div className="flex items-center justify-center">
        <FaSpinner className={`animate-spin text-2xl sm:text-3xl ${isLight ? 'text-amber-600' : 'text-gray-400'} mr-3`} />
        <span className={`text-base sm:text-lg ${textClass}`}>Loading projects...</span>
      </div>
    </div>
  );
};

export default LoadingState; 