# Eframe Internal - Features Documentation

## Department Management

### Department Employees Modal

**Feature**: Click on employees count in department cards to view all employees in that department.

**How to use**:
1. Navigate to the Departments page
2. Find any department card
3. Click on the "Employees" row (the row showing the employee count)
4. A modal will open displaying all employees in that department

**What the modal shows**:
- Employee name
- Department/Division
- Role/Position
- Remarks (if any)
- Total employee count

**Technical Details**:
- Uses the existing API endpoint: `/api/filterations/employees_by_division`
- Modal is responsive and works on both desktop and mobile
- Supports both light and dark themes
- Includes loading states and error handling
- Modal can be closed by clicking the X button, Close button, or clicking outside the modal

**Files Modified**:
- `src/components/Departments/DepartmentCard.jsx` - Added click handler and modal integration
- `src/components/Departments/DepartmentEmployeesModal.jsx` - New modal component

**API Endpoint**:
- `GET /api/filterations/employees_by_division?division={division_name}`
- Returns: Array of employee objects with `employee_id`, `employee_name`, `division_name`, `role_name`, and `remarks`

### Department Projects Modal

**Feature**: Click on projects count in department cards to view all projects in that department.

**How to use**:
1. Navigate to the Departments page
2. Find any department card
3. Click on the "Projects" row (the row showing the project count)
4. A modal will open displaying all projects in that department

**What the modal shows**:
- Project name
- Project lead
- Status with visual indicators
- Priority level with color coding
- Project type
- Deadline
- Completion percentage with progress bar
- Remarks (if any)
- Total project count

**Technical Details**:
- Uses the existing API endpoints: `/api/filterations/project_names_by_division` and `/api/filterations/projects_by_lead_name`
- Modal is responsive and works on both desktop and mobile
- Supports both light and dark themes
- Includes loading states and error handling
- Modal can be closed by clicking the X button, Close button, or clicking outside the modal
- Visual status indicators (checkmark for completed, clock for ongoing, etc.)
- Color-coded priority levels (red for high, yellow for medium, green for low)

**Files Modified**:
- `src/components/Departments/DepartmentCard.jsx` - Added click handler and modal integration
- `src/components/Departments/DepartmentProjectsModal.jsx` - New modal component

**API Endpoints**:
- `GET /api/filterations/project_names_by_division?division={division_name}` - Returns array of project names
- `GET /api/filterations/projects_by_lead_name?lead_name={lead_name}` - Returns detailed project information

## Getting Started

### Prerequisites
- Node.js (v14 or higher)
- MySQL database
- Backend server running on port 3000

### Running the Application

1. **Start the Backend**:
   ```bash
   cd Eframe_Internal_Backend
   npm install
   npm start
   ```

2. **Start the Frontend**:
   ```bash
   cd Eframe_Internal_Frontend
   npm install
   npm run dev
   ```

3. **Access the Application**:
   - Frontend: http://localhost:5173
   - Backend API: http://localhost:3000

## Available Features

### Departments
- View all departments with employee and project counts
- Click on employee count to see detailed employee list
- Click on project count to see detailed project list
- Search and filter departments
- Responsive design for all screen sizes

### Employees
- View all employees
- Add new employees
- Edit employee details
- Filter by department, role, and status

### Projects
- View all projects
- Add new projects
- Edit project details
- Filter by status, priority, and type

### Dashboard
- Overview of key metrics
- Recent activities
- Quick actions
- System status

## Theme Support

The application supports both light and dark themes:
- Automatic theme detection based on system preferences
- Manual theme toggle available
- Consistent styling across all components 