import React from "react";
import { useTheme } from "../../contexts/ThemeContext";
import {
  FaClock,
  FaUsers,
  FaCheckCircle,
  FaExclamationTriangle,
} from "react-icons/fa";
import ActivityItem from "./ActivityItem";

const RecentActivities = () => {
  const { isLight } = useTheme();

  const cardBgClass = isLight
    ? "bg-white border border-yellow-200 shadow-md hover:shadow-lg"
    : "bg-gradient-to-br from-gray-800 to-slate-800 border border-gray-700 shadow-lg hover:shadow-xl";

  const headingClass = isLight ? "text-amber-800" : "text-gray-100";

  const recentActivities = [
    {
      id: 1,
      title: "New Employee Onboarded",
      description: "John Smith joined the Development team",
      time: "2 hours ago",
      icon: <FaUsers />,
      type: "success",
    },
    {
      id: 2,
      title: "Project Milestone Achieved",
      description: "E-Commerce Platform reached 75% completion",
      time: "4 hours ago",
      icon: <FaCheckCircle />,
      type: "success",
    },
    {
      id: 3,
      title: "System Maintenance Scheduled",
      description: "Server maintenance planned for this weekend",
      time: "6 hours ago",
      icon: <FaClock />,
      type: "warning",
    },
    {
      id: 4,
      title: "Budget Review Required",
      description: "Q4 budget review meeting scheduled",
      time: "1 day ago",
      icon: <FaExclamationTriangle />,
      type: "warning",
    },
  ];

  return (
    <div
      className={`lg:col-span-2 ${cardBgClass} rounded-xl p-6 transition-all duration-300`}
    >
      <h2
        className={`text-2xl font-bold ${headingClass} mb-6 flex items-center gap-2`}
      >
        <FaClock className={`${isLight ? "text-amber-600" : "text-gray-400"} flex-shrink-0`} />
        Recent Activities
      </h2>
      <div className="space-y-4">
        {recentActivities.map((activity) => (
          <ActivityItem key={activity.id} activity={activity} />
        ))}
      </div>
    </div>
  );
};

export default RecentActivities;
