import React from "react";
import { useTheme } from "../../contexts/ThemeContext";
import {
  FaBuilding,
  FaUsers,
  FaProjectDiagram,
  FaCode,
  FaUserTie,
  FaBullhorn,
  FaDollarSign,
  FaCogs,
  FaPaintBrush,
  FaChartLine,
  FaHeadset,
  FaShieldAlt,
  FaBook,
  FaTruck,
  FaLaptopCode,
  FaRocket,
  FaDatabase,
  FaMobile,
  FaCloud,
  FaUsers as FaTeam,
  FaHandshake,
  FaGraduationCap,
  FaClipboardList,
  FaBalanceScale,
  FaCalculator,
  FaCreditCard,
  FaChartPie,
  FaAd,
  FaCamera,
  FaPalette,
  FaBrush,
  FaLightbulb,
  FaTools,
  FaIndustry,
  FaWarehouse,
  FaBoxOpen,
  FaMedkit,
  FaHeart,
  FaUtensils,
  FaConciergeBell,
  FaKey,
  FaUserShield,
  FaGavel,
  FaServer,
  FaNetworkWired,
  FaChevronRight,
} from "react-icons/fa";

const DepartmentCard = ({
  department,
  onOpenEmployeesModal,
  onOpenProjectsModal,
}) => {
  const { isLight } = useTheme();

  // Comprehensive department icon and color mapping system
  // Covers 25+ department types with unique icons and colors
  const getDepartmentConfig = (departmentName) => {
    const name = departmentName.toLowerCase();

    // Software & Technology
    if (
      name.includes("software") ||
      name.includes("development") ||
      name.includes("programming")
    ) {
      return { icon: FaLaptopCode, color: "blue-600" };
    } else if (
      name.includes("tech") ||
      name.includes("it") ||
      name.includes("information")
    ) {
      return { icon: FaCode, color: "indigo-600" };
    } else if (
      name.includes("data") ||
      name.includes("database") ||
      name.includes("analytics")
    ) {
      return { icon: FaDatabase, color: "purple-600" };
    } else if (name.includes("mobile") || name.includes("app")) {
      return { icon: FaMobile, color: "green-600" };
    } else if (name.includes("cloud") || name.includes("devops")) {
      return { icon: FaCloud, color: "sky-600" };
    } else if (name.includes("network") || name.includes("infrastructure")) {
      return { icon: FaNetworkWired, color: "slate-600" };
    } else if (name.includes("server") || name.includes("system")) {
      return { icon: FaServer, color: "gray-600" };
    }

    // Human Resources & People
    else if (
      name.includes("hr") ||
      name.includes("human resource") ||
      name.includes("people")
    ) {
      return { icon: FaUserTie, color: "emerald-600" };
    } else if (name.includes("recruitment") || name.includes("talent")) {
      return { icon: FaHandshake, color: "teal-600" };
    } else if (
      name.includes("training") ||
      name.includes("learning") ||
      name.includes("development")
    ) {
      return { icon: FaGraduationCap, color: "amber-600" };
    }

    // Marketing & Communications
    else if (
      name.includes("marketing") ||
      name.includes("brand") ||
      name.includes("promotion")
    ) {
      return { icon: FaBullhorn, color: "pink-600" };
    } else if (name.includes("advertising") || name.includes("campaign")) {
      return { icon: FaAd, color: "rose-600" };
    } else if (name.includes("social") || name.includes("digital marketing")) {
      return { icon: FaBullhorn, color: "violet-600" };
    } else if (name.includes("content") || name.includes("media")) {
      return { icon: FaCamera, color: "fuchsia-600" };
    }

    // Finance & Accounting
    else if (name.includes("finance") || name.includes("financial")) {
      return { icon: FaDollarSign, color: "yellow-600" };
    } else if (name.includes("accounting") || name.includes("audit")) {
      return { icon: FaCalculator, color: "orange-600" };
    } else if (name.includes("banking") || name.includes("payment")) {
      return { icon: FaCreditCard, color: "amber-700" };
    } else if (name.includes("budget") || name.includes("planning")) {
      return { icon: FaChartPie, color: "yellow-700" };
    }

    // Operations & Manufacturing
    else if (name.includes("operations") || name.includes("ops")) {
      return { icon: FaCogs, color: "red-600" };
    } else if (name.includes("manufacturing") || name.includes("production")) {
      return { icon: FaIndustry, color: "orange-700" };
    } else if (name.includes("warehouse") || name.includes("storage")) {
      return { icon: FaWarehouse, color: "stone-600" };
    } else if (
      name.includes("logistics") ||
      name.includes("supply") ||
      name.includes("procurement")
    ) {
      return { icon: FaTruck, color: "red-700" };
    } else if (name.includes("quality") || name.includes("assurance")) {
      return { icon: FaClipboardList, color: "neutral-600" };
    }

    // Design & Creative
    else if (
      name.includes("design") ||
      name.includes("ui") ||
      name.includes("ux")
    ) {
      return { icon: FaPalette, color: "purple-500" };
    } else if (name.includes("creative") || name.includes("art")) {
      return { icon: FaBrush, color: "pink-500" };
    } else if (name.includes("graphics") || name.includes("visual")) {
      return { icon: FaPaintBrush, color: "indigo-500" };
    } else if (name.includes("innovation") || name.includes("research")) {
      return { icon: FaLightbulb, color: "yellow-500" };
    }

    // Sales & Business Development
    else if (name.includes("sales") || name.includes("business development")) {
      return { icon: FaChartLine, color: "green-700" };
    } else if (name.includes("customer success") || name.includes("account")) {
      return { icon: FaHandshake, color: "blue-700" };
    }

    // Support & Services
    else if (
      name.includes("support") ||
      name.includes("customer service") ||
      name.includes("help")
    ) {
      return { icon: FaHeadset, color: "cyan-600" };
    } else if (name.includes("maintenance") || name.includes("facility")) {
      return { icon: FaTools, color: "slate-700" };
    } else if (name.includes("hospitality") || name.includes("service")) {
      return { icon: FaConciergeBell, color: "indigo-700" };
    }

    // Legal & Compliance
    else if (
      name.includes("legal") ||
      name.includes("law") ||
      name.includes("compliance")
    ) {
      return { icon: FaGavel, color: "gray-700" };
    } else if (name.includes("security") || name.includes("safety")) {
      return { icon: FaUserShield, color: "red-800" };
    } else if (name.includes("risk") || name.includes("audit")) {
      return { icon: FaShieldAlt, color: "orange-800" };
    }

    // Health & Wellness
    else if (
      name.includes("health") ||
      name.includes("medical") ||
      name.includes("wellness")
    ) {
      return { icon: FaMedkit, color: "green-800" };
    } else if (name.includes("safety") || name.includes("environment")) {
      return { icon: FaHeart, color: "red-500" };
    }

    // Food & Hospitality
    else if (
      name.includes("food") ||
      name.includes("catering") ||
      name.includes("restaurant")
    ) {
      return { icon: FaUtensils, color: "amber-800" };
    }

    // Administration & Management
    else if (
      name.includes("admin") ||
      name.includes("management") ||
      name.includes("executive")
    ) {
      return { icon: FaKey, color: "slate-800" };
    }

    // Project Management
    else if (name.includes("project") || name.includes("program")) {
      return { icon: FaRocket, color: "blue-800" };
    }

    // Default fallback
    else {
      return { icon: FaBuilding, color: "gray-500" };
    }
  };

  const departmentConfig = getDepartmentConfig(department.name);
  const IconComponent = departmentConfig.icon;

  // 🎨 COLOR SCHEME OPTIONS - Choose one:

  // ✅ OPTION 1: UNIQUE COLORS (Current - Recommended)
  // Each department gets its own color for better visual distinction
  const iconColor = departmentConfig.color;

  // 🔄 OPTION 2: UNIFORM COLORS (Uncomment to switch)
  // All departments use the same color for consistency
  // const iconColor = isLight ? 'blue-600' : 'blue-400';

  // 🎯 OPTION 3: THEME-BASED COLORS (Alternative)
  // Uses website's theme colors consistently
  // const iconColor = isLight ? 'amber-600' : 'gray-400';

  // Create dynamic card styling based on department color
  const cardBgClass = isLight
    ? `bg-white border-l-4 border-l-${iconColor} border border-gray-200 shadow-md hover:shadow-lg`
    : `bg-gradient-to-br from-gray-800 to-slate-800 border-l-4 border-l-${iconColor} border border-gray-700 shadow-lg hover:shadow-xl`;

  const headingClass = isLight ? "text-amber-800" : "text-white";

  const textClass = isLight ? "text-amber-700" : "text-gray-200";

  return (
    <div
      className={`${cardBgClass} rounded-xl p-6 transition-all duration-300 hover:scale-105 cursor-pointer`}
    >
      <div className="flex items-center gap-3 mb-4">
        <div
          className={`p-3 rounded-lg flex items-center justify-center ${
            isLight
              ? `bg-${iconColor}/10 border border-${iconColor}/20`
              : "bg-gray-700 border border-gray-600"
          }`}
        >
          <IconComponent
            className={`text-${iconColor} text-2xl drop-shadow-sm flex-shrink-0`}
          />
        </div>
        <div>
          <h3
            className={`text-xl font-bold ${
              isLight ? "text-amber-600" : "text-white"
            }`}
          >
            {department.name}
          </h3>
        </div>
      </div>

      <div className="space-y-3 mb-4">
        <div
          className={`flex items-center justify-between cursor-pointer border border-transparent p-2 rounded-lg transition-colors group ${
            isLight
              ? "hover:bg-blue-50 hover:border-blue-200"
              : "hover:bg-blue-900/30 hover:border-blue-600"
          }`}
          onClick={() => onOpenEmployeesModal(department)}
        >
          <div className="flex items-center gap-2">
            <FaUsers
              className={`${
                isLight ? "text-gray-500" : "text-gray-300"
              } text-sm flex-shrink-0`}
            />
            <span className={`text-sm ${textClass}`}>Employees</span>
          </div>
          <div className="flex items-center gap-2">
            <span className={`font-semibold ${headingClass}`}>
              {department.employees}
            </span>
            <FaChevronRight
              className={`text-xs ${
                isLight ? "text-gray-400" : "text-gray-300"
              } group-hover:text-blue-500 transition-colors flex-shrink-0`}
            />
          </div>
        </div>
        <div
          className={`flex items-center justify-between cursor-pointer border border-transparent p-2 rounded-lg transition-colors group ${
            isLight
              ? "hover:bg-purple-50 hover:border-purple-200"
              : "hover:bg-purple-900/30 hover:border-purple-600"
          }`}
          onClick={() => onOpenProjectsModal(department)}
        >
          <div className="flex items-center gap-2">
            <FaProjectDiagram
              className={`${
                isLight ? "text-gray-500" : "text-gray-300"
              } text-sm flex-shrink-0`}
            />
            <span className={`text-sm ${textClass}`}>Projects</span>
          </div>
          <div className="flex items-center gap-2">
            <span className={`font-semibold ${headingClass}`}>
              {department.projects}
            </span>
            <FaChevronRight
              className={`text-xs ${
                isLight ? "text-gray-400" : "text-gray-300"
              } group-hover:text-purple-500 transition-colors flex-shrink-0`}
            />
          </div>
        </div>
      </div>
    </div>
  );
};

export default DepartmentCard;
