import React from 'react';
import { useTheme } from '../../contexts/ThemeContext';
import { FaTimes, FaTrash, FaSpinner, FaExclamationTriangle } from 'react-icons/fa';

const DeleteConfirmModal = ({ isOpen, onClose, employee, onConfirm, loading }) => {
  const { isLight } = useTheme();

  if (!isOpen || !employee) {
    return null;
  }

  const modalBgClass = isLight 
    ? 'bg-white' 
    : 'bg-slate-800';

  const textClass = isLight 
    ? 'text-gray-700' 
    : 'text-gray-300';

  const headingClass = isLight 
    ? 'text-red-600' 
    : 'text-red-400';

  return (
    <div className="fixed inset-0 flex items-center justify-center z-50 p-4" style={{ backgroundColor: 'rgba(0, 0, 0, 0.1)' }}>
      <div 
        className="absolute inset-0" 
        onClick={onClose}
        style={{ cursor: 'pointer' }}
        title="Click to close"
      />
      <div 
        className={`${modalBgClass} rounded-lg max-w-md w-full relative z-60 border ${isLight ? 'border-gray-200' : 'border-slate-600 shadow-2xl'}`}
        onClick={(e) => e.stopPropagation()}
      >
        {/* Header */}
        <div className={`p-6 border-b ${isLight ? 'border-gray-200' : 'border-slate-600'}`}>
          <div className="flex items-center justify-between">
            <div className="flex items-center gap-3">
              <div className={`p-2 rounded-full ${isLight ? 'bg-red-100' : 'bg-red-900'}`}>
                <FaExclamationTriangle className={`text-lg ${headingClass}`} />
              </div>
              <div>
                <h2 className={`text-xl font-semibold ${headingClass}`}>
                  Delete Employee
                </h2>
                <p className={`text-sm ${textClass} opacity-75`}>
                  This action cannot be undone
                </p>
              </div>
            </div>
            <button
              onClick={onClose}
              disabled={loading}
              className={`p-2 rounded-md transition-colors flex items-center justify-center w-8 h-8 ${
                isLight 
                  ? 'text-gray-400 hover:text-gray-600 hover:bg-gray-100' 
                  : 'text-gray-400 hover:text-gray-200 hover:bg-gray-700'
              } disabled:opacity-50`}
            >
              <FaTimes className="flex-shrink-0" />
            </button>
          </div>
        </div>

        {/* Content */}
        <div className="p-6 max-h-[70vh] overflow-y-auto">
          <div className={`${textClass} mb-4`}>
            <p className="mb-4 text-base">
              Are you sure you want to delete this employee? This action cannot be undone.
            </p>
            
            {/* Employee Details */}
            <div className={`p-4 rounded-md border ${
              isLight 
                ? 'bg-gray-50 border-gray-200' 
                : 'bg-slate-700 border-slate-600'
            }`}>
              <div className="space-y-3">
                <div className="flex justify-between items-center">
                  <span className={`font-medium ${textClass}`}>Employee ID:</span>
                  <span className={`font-mono text-sm ${isLight ? 'text-gray-900' : 'text-gray-100'}`}>
                    {employee.employee_id}
                  </span>
                </div>
                <div className="flex justify-between items-center">
                  <span className={`font-medium ${textClass}`}>Name:</span>
                  <span className={`font-medium ${isLight ? 'text-gray-900' : 'text-gray-100'}`}>
                    {employee.employee_name}
                  </span>
                </div>
                <div className="flex justify-between items-center">
                  <span className={`font-medium ${textClass}`}>Division:</span>
                  <span className={`text-sm ${textClass}`}>
                    {employee.division_name || 'Not Assigned'}
                  </span>
                </div>
                <div className="flex justify-between items-center">
                  <span className={`font-medium ${textClass}`}>Role:</span>
                  <span className={`text-sm ${textClass}`}>
                    {employee.role_name || 'Not Assigned'}
                  </span>
                </div>
              </div>
            </div>
          </div>

          {/* Buttons */}
          <div className={`flex gap-3 pt-4 mt-4 border-t ${isLight ? 'border-gray-200' : 'border-slate-600'}`}>
            <button
              type="button"
              onClick={onClose}
              disabled={loading}
              className={`flex-1 px-4 py-2 rounded-md font-medium text-sm transition-colors border ${
                isLight
                  ? 'border-gray-300 text-gray-700 hover:bg-gray-50 bg-white'
                  : 'border-slate-600 text-slate-300 hover:bg-slate-700 bg-slate-800 hover:border-slate-500'
              } disabled:opacity-50 disabled:cursor-not-allowed`}
            >
              Cancel
            </button>
            <button
              type="button"
              onClick={onConfirm}
              disabled={loading}
              className="flex-1 px-4 py-2 rounded-md font-medium text-sm transition-colors disabled:opacity-50 disabled:cursor-not-allowed flex items-center justify-center gap-2 bg-red-600 hover:bg-red-700 text-white shadow-lg"
            >
              {loading ? (
                <>
                  <FaSpinner className="animate-spin text-sm flex-shrink-0" />
                  <span>Deleting...</span>
                </>
              ) : (
                <>
                  <FaTrash className="text-sm flex-shrink-0" />
                  <span>Delete Employee</span>
                </>
              )}
            </button>
          </div>
        </div>
      </div>
    </div>
  );
};

export default DeleteConfirmModal; 