import React from 'react';
import { useTheme } from '../../contexts/ThemeContext';
import { FaFilter, FaCheck } from 'react-icons/fa';

const FilterPopup = ({ 
  filterType, 
  isOpen, 
  onToggle, 
  options, 
  selectedValue, 
  onSelect, 
  isLoading, 
  filterRef 
}) => {
  const { isLight } = useTheme();

  const getFilterLabel = (type) => {
    switch (type) {
      case 'division': return 'Division';
      case 'role': return 'Role';
      case 'project': return 'Project Name';
      default: return type;
    }
  };

  const getActiveColor = (type) => {
    switch (type) {
      case 'division': return isLight ? 'text-blue-600 hover:bg-blue-100' : 'text-blue-400 hover:bg-blue-900';
      case 'role': return isLight ? 'text-blue-600 hover:bg-blue-100' : 'text-blue-400 hover:bg-blue-900';
      case 'project': return isLight ? 'text-blue-600 hover:bg-blue-100' : 'text-blue-400 hover:bg-blue-900';
      default: return isLight ? 'text-gray-600 hover:bg-gray-100' : 'text-gray-400 hover:bg-gray-700';
    }
  };

  const getInactiveColor = (type) => {
    return isLight ? 'text-gray-600 hover:bg-gray-100' : 'text-gray-400 hover:bg-gray-700';
  };

  const isActive = selectedValue !== 'All';
  const colorClass = isActive ? getActiveColor(filterType) : getInactiveColor(filterType);

  return (
    <div className="flex items-center justify-center gap-2 relative" ref={filterRef}>
      <span>{getFilterLabel(filterType)}</span>
      <button
        onClick={onToggle}
        disabled={isLoading}
        className={`p-1 rounded hover:bg-opacity-20 transition-colors flex items-center justify-center w-6 h-6 ${colorClass} ${
          isLoading ? 'opacity-50 cursor-not-allowed' : 'cursor-pointer'
        }`}
        title={`Filter by ${filterType}`}
      >
        <FaFilter className="text-xs flex-shrink-0" />
      </button>

      {/* Filter Popup */}
      {isOpen && (
        <div className={`absolute top-full left-1/2 transform -translate-x-1/2 mt-2 w-48 max-h-60 overflow-y-auto rounded-lg shadow-lg border z-50 ${
          isLight 
            ? 'bg-white border-gray-200' 
            : 'bg-gray-800 border-gray-600'
        }`}>
          <div className="py-1">
            <button
              onClick={() => onSelect('All')}
              className={`w-full px-4 py-2 text-left text-sm transition-colors flex items-center justify-between ${
                selectedValue === 'All'
                  ? isLight ? 'bg-blue-50 text-blue-600' : 'bg-blue-900/20 text-blue-400'
                  : isLight ? 'text-gray-700 hover:bg-gray-50' : 'text-gray-300 hover:bg-gray-700'
              }`}
            >
              <span>All {getFilterLabel(filterType)}s</span>
              {selectedValue === 'All' && <FaCheck className="text-xs flex-shrink-0" />}
            </button>
            {options.map(option => {
              const optionValue = option[`${filterType}_name`] || option.name || option;
              const optionId = option[`${filterType}_id`] || option.id;
              return (
                <button
                  key={optionId || optionValue}
                  onClick={() => onSelect(optionValue)}
                  className={`w-full px-4 py-2 text-left text-sm transition-colors flex items-center justify-between ${
                    selectedValue === optionValue
                      ? isLight ? 'bg-blue-50 text-blue-600' : 'bg-blue-900/20 text-blue-400'
                      : isLight ? 'text-gray-700 hover:bg-gray-50' : 'text-gray-300 hover:bg-gray-700'
                  }`}
                >
                  <span>{optionValue}</span>
                  {selectedValue === optionValue && <FaCheck className="text-xs flex-shrink-0" />}
                </button>
              );
            })}
          </div>
        </div>
      )}
    </div>
  );
};

export default FilterPopup; 