import React from "react";
import { useTheme } from "../../contexts/ThemeContext";

const FormsMessage = () => {
  const { isLight } = useTheme();

  // Theme-based styling classes
  const cardBgClass = isLight
    ? "bg-white border border-yellow-200 shadow-md hover:shadow-lg"
    : "bg-gradient-to-br from-gray-800 to-slate-800 border border-gray-700 shadow-lg hover:shadow-xl";

  return (
    <div className={`${cardBgClass} rounded-xl px-4 sm:px-6 py-3 sm:py-4 transition-all duration-300`}>
      <div className="flex items-center">
        <div className="flex-shrink-0">
          <div className={`w-8 h-8 rounded-full flex items-center justify-center ${
            isLight ? "bg-blue-100" : "bg-blue-900"
          }`}>
            <svg className={`w-5 h-5 ${isLight ? "text-blue-600" : "text-blue-300"}`} viewBox="0 0 20 20" fill="currentColor">
              <path fillRule="evenodd" d="M18 10a8 8 0 11-16 0 8 8 0 0116 0zm-7-4a1 1 0 11-2 0 1 1 0 012 0zM9 9a1 1 0 000 2v3a1 1 0 001 1h1a1 1 0 100-2v-3a1 1 0 00-1-1H9z" clipRule="evenodd" />
            </svg>
          </div>
        </div>
        <div className="ml-3">
          <p className={`${isLight ? "text-blue-800" : "text-blue-200"} text-sm font-medium`}>
            <strong>Important:</strong> Please download the form and submit underneath the respective projects in the projects page.
          </p>
        </div>
      </div>
    </div>
  );
};

export default FormsMessage;
