import React from "react";
import { FaEye } from "react-icons/fa";

const LeadActions = ({ project, onView, isLight }) => {
  return (
    <div className="flex items-center justify-center gap-1">
      <button
        onClick={() => onView(project)}
        className={`px-2 py-1 rounded-md transition-all duration-200 hover:scale-105 flex items-center justify-center gap-1 text-xs font-medium ${
          isLight
            ? "bg-blue-500 hover:bg-blue-600 text-white"
            : "bg-blue-600 hover:bg-blue-700 text-white"
        }`}
        title="View Project Details"
      >
        <FaEye size={10} className="flex-shrink-0" />
        <span>View</span>
      </button>
    </div>
  );
};

export default LeadActions;
