import React from 'react';
import { useTheme } from '../../contexts/ThemeContext';
import { FaTrash, FaTimes, FaExclamationTriangle } from 'react-icons/fa';

const DeleteConfirmationModal = ({ 
  isOpen, 
  onClose, 
  onConfirm, 
  project, 
  loading 
}) => {
  const { isLight } = useTheme();

  if (!isOpen || !project) return null;

  const modalBgClass = isLight 
    ? 'bg-white' 
    : 'bg-slate-800';

  const buttonClass = isLight
    ? 'bg-gradient-to-r from-yellow-500 to-amber-500 hover:from-yellow-600 hover:to-amber-600 text-white'
    : 'bg-blue-600 hover:bg-blue-700 text-white shadow-lg';

  const textClass = isLight 
    ? 'text-amber-700' 
    : 'text-slate-300';

  return (
    <div className="fixed inset-0 flex items-center justify-center z-50 p-4" style={{ backgroundColor: 'rgba(0, 0, 0, 0.1)' }}>
      <div 
        className="absolute inset-0" 
        onClick={onClose}
        style={{ cursor: 'pointer' }}
        title="Click to close"
      />
      <div 
        className={`${modalBgClass} rounded-lg max-w-md w-full relative z-60 border ${isLight ? 'border-yellow-200' : 'border-slate-600 shadow-2xl'}`}
        onClick={(e) => e.stopPropagation()}
      >
        {/* Header */}
        <div className={`p-6 border-b ${isLight ? 'border-yellow-200' : 'border-slate-600'}`}>
          <div className="flex items-center justify-between">
            <div className="flex items-center gap-3">
              <div className={`p-2 rounded-full ${isLight ? 'bg-red-100' : 'bg-red-900'}`}>
                <FaExclamationTriangle className={`text-lg ${isLight ? 'text-red-600' : 'text-red-400'}`} />
              </div>
              <div>
                <h2 className={`text-xl font-semibold ${isLight ? 'text-red-800' : 'text-slate-100'}`}>
                  Confirm Deletion
                </h2>
                <p className={`text-sm ${isLight ? 'text-red-700' : 'text-slate-300'} opacity-75`}>
                  This action cannot be undone
                </p>
              </div>
            </div>
            <button
              onClick={onClose}
              disabled={loading}
              className={`p-2 rounded-md transition-colors flex items-center justify-center w-8 h-8 ${
                isLight 
                  ? 'text-gray-400 hover:text-gray-600 hover:bg-gray-100' 
                  : 'text-gray-400 hover:text-gray-200 hover:bg-gray-700'
              } disabled:opacity-50`}
            >
              <FaTimes className="flex-shrink-0" />
            </button>
          </div>
        </div>

        {/* Content */}
        <div className="p-6">
          <div className="text-center">
            <div className={`p-4 rounded-full inline-flex items-center justify-center mb-4 ${isLight ? 'bg-red-100' : 'bg-red-900'}`}>
              <FaTrash className={`text-2xl ${isLight ? 'text-red-600' : 'text-red-400'} flex-shrink-0`} />
            </div>
            
            <h3 className={`text-lg font-medium mb-2 ${isLight ? 'text-gray-900' : 'text-slate-100'}`}>
              Delete Project
            </h3>
            
            <p className={`text-sm mb-4 ${textClass}`}>
              Are you sure you want to delete the project <strong>"{project.project_name}"</strong>?
            </p>
            
            <p className={`text-xs ${isLight ? 'text-gray-600' : 'text-slate-400'}`}>
              This action will permanently remove the project and all associated data. This cannot be undone.
            </p>
          </div>
        </div>

        {/* Footer */}
        <div className={`flex gap-3 p-6 border-t ${isLight ? 'border-yellow-200' : 'border-slate-600'}`}>
          <button
            type="button"
            onClick={onClose}
            disabled={loading}
            className={`flex-1 px-4 py-2 rounded-md font-medium text-sm transition-colors border ${
              isLight
                ? 'border-yellow-300 text-amber-700 hover:bg-yellow-50 bg-white'
                : 'border-slate-600 text-slate-300 hover:bg-slate-700 bg-slate-800 hover:border-slate-500'
            } disabled:opacity-50 disabled:cursor-not-allowed`}
          >
            Cancel
          </button>
          <button
            onClick={() => onConfirm(project)}
            disabled={loading}
            className={`flex-1 px-4 py-2 rounded-md font-medium text-sm transition-colors disabled:opacity-50 disabled:cursor-not-allowed flex items-center justify-center gap-2 ${
              isLight 
                ? 'bg-red-500 hover:bg-red-600 text-white' 
                : 'bg-red-600 hover:bg-red-700 text-white'
            }`}
          >
            {loading ? (
              <>
                <div className="animate-spin rounded-full h-4 w-4 border-b-2 border-white flex-shrink-0"></div>
                <span>Deleting...</span>
              </>
            ) : (
              <>
                <FaTrash className="text-sm flex-shrink-0" />
                <span>Delete Project</span>
              </>
            )}
          </button>
        </div>
      </div>
    </div>
  );
};

export default DeleteConfirmationModal; 